/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MKaisyaDao;
import jp.mosp.system.dto.MKaisyaDto;
import jp.mosp.system.vo.KaisyaMasterListVo;

public class KaisyaMasterListAction extends MosPAction {

	private static final String CMD_KAISYA_MASTER_LIST_SHOW       = "S2010";
	private static final String CMD_KAISYA_MASTER_LIST_SEARCH     = "S2011";
	private static final String CMD_KAISYA_MASTER_LIST_RE_SEARCH  = "S2012";
	private static final String CMD_KAISYA_MASTER_LIST_SORT       = "S2013";

	/**
	 * RXgN^
	 */
	public KaisyaMasterListAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		// VO̎擾
		KaisyaMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof KaisyaMasterListVo) {
			vo = (KaisyaMasterListVo)obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new KaisyaMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_KAISYA_MASTER_LIST_SHOW)) {
			// lɃZbg	
			vo.setSearchmode(KaisyaMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			searchCompanyList(vo);
			vo.setFormerKey(vo.KEY_JCODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(KaisyaMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_RE_SEARCH)) {
			// Č
			if(vo.getSearchmode() == KaisyaMasterListVo.SEARCH_ON){
				session.removeAttribute(MospConst.ATT_DTO);
				searchCompanyList(vo);
				vo.setPageButton();
				sortList(vo);	
			}
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ƏXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchCompanyList(KaisyaMasterListVo vo) throws Exception {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtJCode(), vo.getTxtKaiMei()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryJCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, KaisyaMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(KaisyaMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator getComparator(String key, KaisyaMasterListVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_JCODE)) {
			comp = new CompJCode();
		} else if (key.equals(vo.KEY_KAIMEI)) {
			comp = new CompKaiMei();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ƏR[hɂrNX
	 */
	protected static class CompJCode implements Comparator, Serializable {
		private static final long serialVersionUID = 4221017842550886498L;
		public int compare(Object obj1, Object obj2) {
			MKaisyaDto dto1 = (MKaisyaDto)obj1;
			MKaisyaDto dto2 = (MKaisyaDto)obj2;
			return dto1.getId().compareTo(dto2.getId());
		}
	}

	/**
	 * Ə̂ɂrNX
	 */
	protected static class CompKaiMei implements Comparator, Serializable {
		private static final long serialVersionUID = -8838582673151573558L;
		public int compare(Object obj1, Object obj2) {
			MKaisyaDto dto1 = (MKaisyaDto)obj1;
			MKaisyaDto dto2 = (MKaisyaDto)obj2;
			return dto1.getKaiMei().compareTo(dto2.getKaiMei());
		}
	}

}
